/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.DistancedFollowParentGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1330;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4466;
import net.minecraft.class_4802;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Elephant
extends NaturalistAnimal
implements class_5354,
NaturalistGeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.elephant.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.elephant.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.elephant.run");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Boolean> DRINKING = class_2945.method_12791(Elephant.class, (class_2941)class_2943.field_13323);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private static final class_2940<Integer> REMAINING_ANGER_TIME = class_2945.method_12791(Elephant.class, (class_2941)class_2943.field_13327);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public Elephant(class_1299<? extends NaturalistAnimal> entityType, class_1937 level) {
        super(entityType, level);
        this.method_49477(1.0f);
    }

    @NotNull
    protected class_1330 method_5963() {
        return new SmartBodyHelper((class_1308)this);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new MMPathNavigatorGround((class_1308)this, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23722, 1.2).method_26868(class_5134.field_23718, 0.75).method_26868(class_5134.field_23717, 15.0);
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        class_1296.class_4697 ageableMobGroupData;
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(true);
        }
        if ((ageableMobGroupData = (class_1296.class_4697)spawnData).method_22432() > 1) {
            this.method_5614(-24000);
        }
        ageableMobGroupData.method_22435();
        class_5819 random = level.method_8409();
        this.method_5996(class_5134.field_23717).method_26837(new class_1322("Random spawn bonus", random.method_43385(0.0, 0.11485000000000001), class_1322.class_1323.field_6330));
        return spawnData;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return (class_1296)NaturalistEntityTypes.ELEPHANT.get().method_5883((class_1937)serverLevel);
    }

    public void method_5958() {
        if (this.method_5962().method_6241()) {
            this.method_5728(this.method_5962().method_6242() >= 1.2);
        } else {
            this.method_5728(false);
        }
        super.method_5958();
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1338((class_1314)this, class_4466.class, 8.0f, 1.3, 1.3));
        this.field_6201.method_6277(2, (class_1352)new ElephantMeleeAttackGoal((class_1314)this, 1.2, true));
        this.field_6201.method_6277(3, (class_1352)new BabyPanicGoal((class_1314)this, 1.3));
        this.field_6201.method_6277(4, (class_1352)new DistancedFollowParentGoal(this, 1.2, 24.0, 6.0, 12.0));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new BabyHurtByTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((Elephant)this).method_29515(arg_0)));
        this.field_6185.method_6277(5, (class_1352)new class_5398((class_1308)this, false));
    }

    public int method_5986() {
        return 35;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return NaturalistSoundEvents.ELEPHANT_HURT.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return NaturalistSoundEvents.ELEPHANT_AMBIENT.get();
    }

    public boolean method_6121(class_1297 target) {
        boolean shouldHurt = target.method_5643(target.method_48923().method_48812((class_1309)this), (float)this.method_26825(class_5134.field_23721));
        if (shouldHurt && target instanceof class_1309) {
            class_1309 livingEntity = (class_1309)target;
            class_243 knockbackDirection = new class_243((double)this.method_24515().method_10263() - target.method_23317(), 0.0, (double)this.method_24515().method_10260() - target.method_23321()).method_1029();
            float shieldBlockModifier = livingEntity.method_6061(target.method_48923().method_48812((class_1309)this)) ? 0.5f : 1.0f;
            livingEntity.method_6005((double)shieldBlockModifier * 3.0, knockbackDirection.method_10216(), knockbackDirection.method_10215());
            double knockbackResistance = Math.max(0.0, 1.0 - livingEntity.method_26825(class_5134.field_23718));
            livingEntity.method_18799(livingEntity.method_18798().method_1031(0.0, 0.5 * knockbackResistance, 0.0));
        }
        this.method_5783(class_3417.field_15240, 1.0f, 1.0f);
        return shouldHurt;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(REMAINING_ANGER_TIME, (Object)0);
        this.field_6011.method_12784(DRINKING, (Object)false);
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        this.method_29517(pCompound);
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.method_29512(this.method_37908(), pCompound);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }

    public void method_29514(int pTime) {
        this.field_6011.method_12778(REMAINING_ANGER_TIME, (Object)pTime);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(REMAINING_ANGER_TIME);
    }

    public void method_29513(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    @Nullable
    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @NotNull
    private <E extends Elephant> PlayState predicate(AnimationState<E> event) {
        if (this.method_6109() || this.method_5968() != null) {
            event.setControllerSpeed(1.3f + event.getLimbSwingAmount());
        }
        if (event.isMoving()) {
            if (this.method_5624()) {
                event.getController().setAnimation(RUN);
            } else {
                event.getController().setAnimation(WALK);
            }
        } else {
            event.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private <E extends Elephant> PlayState swingPredicate(@NotNull AnimationState<E> event) {
        if (this.field_6252 && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().thenPlay("animation.sf_nba.elephant.swing"));
            this.field_6252 = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "swingController", 0, this::swingPredicate)});
    }

    static class ElephantMeleeAttackGoal
    extends class_1366 {
        public ElephantMeleeAttackGoal(class_1314 pathfinderMob, double speedMultiplier, boolean followingTargetEvenIfNotSeen) {
            super(pathfinderMob, speedMultiplier, followingTargetEvenIfNotSeen);
        }

        protected double method_6289(class_1309 attackTarget) {
            return class_3532.method_27285((float)this.field_6503.method_17681());
        }
    }
}

